#pragma once

#include <maps/wikimap/mapspro/services/editor/src/commit.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "comment_tasks_processor.h"

#include <maps/wikimap/mapspro/libs/acl/include/user.h>
#include <yandex/maps/wiki/revision/commit.h>
#include <yandex/maps/wiki/social/task.h>

namespace maps::wiki {

class ObserverCollection;
class SocialModerationTasksClose;
template<>
struct controller::ResultType<SocialModerationTasksClose>
{
    Token token;
    social::TaskIds taskIds;
    boost::optional<CommitModel> revertingCommitModel;
};

class SocialModerationTasksClose:
        public SocialModerationCommentTasksProcessor<SocialModerationTasksClose, social::CloseResolution>
{
public:
    SocialModerationTasksClose(
        const ObserverCollection& observers,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();

protected:
    virtual void control();

private:
    void processClose(
        BranchContext& branchCtx,
        const social::Gateway& socialGateway,
        const acl::User& user,
        const social::Tasks& tasks) const;

    void processRevert(
        BranchContext& branchCtx,
        const social::Gateway& socialGateway,
        const social::Tasks& tasks);

    void processFeedbackAccept(
        const social::Gateway& socialGateway,
        const social::Tasks& tasks) const;
};

} // namespace maps::wiki
