#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <yandex/maps/wiki/social/task.h>

namespace maps {
namespace wiki {

class ObserverCollection;
class SocialModerationTasksDefer;
template<>
struct controller::ResultType<SocialModerationTasksDefer>
{
    Token token;
    social::TaskIds taskIds;
};

class SocialModerationTasksDefer : public controller::BaseController<SocialModerationTasksDefer>
{
public:
    struct Request
    {
        Request(
            TUid uid,
            const social::TaskIds& taskIds,
            const std::string& expiresAt);

        Request(TUid uid, const std::string& json);

        std::string dump() const;
        TUid userId() const { return user; }

        const TUid user;
        social::TaskIds taskIds;
        std::string expiresAt;
    };

    SocialModerationTasksDefer(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
