#include "tasks_release.h"
#include "helpers.h"
#include <maps/wikimap/mapspro/services/editor/src/acl_utils.h>
#include <maps/wikimap/mapspro/services/editor/src/moderation.h>
#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/exception.h>

#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <yandex/maps/wiki/social/gateway.h>

namespace maps {
namespace wiki {

namespace {

const std::string TASK_METHOD_NAME = "SocialModerationTasksRelease";

} // namespace

SocialModerationTasksRelease::Request::Request(TUid uid)
    : user(uid)
{
    CHECK_REQUEST_PARAM(uid);
}

std::string
SocialModerationTasksRelease::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << user;
    return ss.str();
}


SocialModerationTasksRelease::SocialModerationTasksRelease(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID)
    : controller::BaseController<SocialModerationTasksRelease>(BOOST_CURRENT_FUNCTION, asyncTaskID)
    , request_(request)
{}

std::string
SocialModerationTasksRelease::printRequest() const
{
    return request_.dump();
}

void
SocialModerationTasksRelease::control()
{
    auto branchCtx = CheckedTrunkBranchContextFacade().acquireWrite();

    checkUserActiveStatus(branchCtx, request_.user);

    auto modConsole = social::Gateway(branchCtx.txnSocial()).moderationConsole(request_.user);
    result_->taskIds = modConsole.releaseTasks();

    result_->token = branchCtx.commit();
}

const std::string&
SocialModerationTasksRelease::taskName()
{
    return TASK_METHOD_NAME;
}

} // namespace wiki
} // namespace maps
