#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <yandex/maps/wiki/social/task.h>

namespace maps {
namespace wiki {

class ObserverCollection;
class SocialModerationTasksRelease;
template<>
struct controller::ResultType<SocialModerationTasksRelease>
{
    social::TaskIds taskIds;
    Token token;
};

class SocialModerationTasksRelease : public controller::BaseController<SocialModerationTasksRelease>
{
public:
    struct Request
    {
        Request(TUid uid);

        std::string dump() const;
        TUid userId() const { return user; }

        const TUid user;
    };

    SocialModerationTasksRelease(
        const ObserverCollection&,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();
    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
