#pragma once

#include <maps/wikimap/mapspro/services/editor/src/commit.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "comment_tasks_processor.h"

#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <yandex/maps/wiki/revision/commit.h>
#include <yandex/maps/wiki/social/gateway.h>
#include <yandex/maps/wiki/social/task.h>

namespace maps {
namespace wiki {

class BranchContext;
class ObserverCollection;
class SocialModerationTasksResolve;
template<>
struct controller::ResultType<SocialModerationTasksResolve>
{
    Token token;
    social::TaskIds taskIds;
    boost::optional<CommitModel> revertingCommitModel;
};

class SocialModerationTasksResolve:
    public SocialModerationCommentTasksProcessor<SocialModerationTasksResolve, social::ResolveResolution>
{
public:
    SocialModerationTasksResolve(
        const ObserverCollection& observers,
        const Request& request,
        taskutils::TaskID asyncTaskID = 0);

    static const std::string& taskName();

protected:
    virtual void control();

private:
    social::TaskIds resolveTasks();

    social::TaskIds processEditsResolve(
        BranchContext& branchCtx,
        const social::Gateway& socialGateway,
        const acl::User& user,
        const social::Tasks& tasks,
        bool isUserCartographer);

    void processEditsRevert(
        BranchContext& branchCtx,
        const social::Gateway& socialGateway,
        const social::Tasks& tasks,
        bool isUserCartographer);
};

} // namespace wiki
} // namespace maps
