#include "tasks_stat.h"

#include <maps/wikimap/mapspro/services/editor/src/acl_utils.h>
#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>

#include <yandex/maps/wiki/social/gateway.h>

namespace maps::wiki {

namespace {
const std::string TASK_METHOD_NAME = "SocialModerationTasksStat";
} // namespace

SocialModerationTasksStat::SocialModerationTasksStat(const Request& request)
    : controller::BaseController<SocialModerationTasksStat>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

const std::string&
SocialModerationTasksStat::taskName()
{
    return TASK_METHOD_NAME;
}

std::string
SocialModerationTasksStat::Request::dump() const
{
    std::stringstream ss;
    ss << " uid: " << uid;
    ss << " time zone: " << tzInMinutes;
    return ss.str();
}

std::string
SocialModerationTasksStat::printRequest() const
{
    return request_.dump();
}

void
SocialModerationTasksStat::control()
{
    auto tokenSocial = getSocialToken(request_.token);
    auto workSocial = cfg()->poolSocial().slaveTransaction(tokenSocial);
    social::Gateway gateway(*workSocial);

    auto modConsole = gateway.superModerationConsole(request_.uid);
    result_->todayProcessedCount = modConsole.todayProcessedCount(request_.tzInMinutes);
}

} // namespace maps::wiki
