#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps {
namespace wiki {

class SocialModerationTasksStat;

template<>
struct controller::ResultType<SocialModerationTasksStat>
{
    size_t todayProcessedCount;
};

class SocialModerationTasksStat : public controller::BaseController<SocialModerationTasksStat>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
        int tzInMinutes;
        Token token;
    };

    explicit SocialModerationTasksStat(const Request& request);

    virtual ~SocialModerationTasksStat() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace wiki
} // namespace maps
