#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps::wiki {

class ObserverCollection;
class CreateSpravTask;
template<>
struct controller::ResultType<CreateSpravTask>
{
    std::string taskName;
    Token token;
};

class CreateSpravTask
    : public controller::BaseController<CreateSpravTask>
{
public:
    struct Request
    {
        std::string dump() const;

        std::string body;
        TUid user;
        TOid objectId;
    };

    explicit CreateSpravTask(const Request& request);

    static const std::string& taskName();
    std::string printRequest() const override;

protected:
    void control() override;


private:
    Request request_;
};

} // namespace maps::wiki
