#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include <maps/wikimap/mapspro/services/editor/src/sprav/sprav_task.h>

namespace maps::wiki {

class GetSpravTasks;
template<>
struct controller::ResultType<GetSpravTasks>
{
    std::vector<SpravTask> tasks;
    size_t total;
    size_t limit;
    size_t offset;
};

class GetSpravTasks: public controller::BaseController<GetSpravTasks>
{
public:
    struct Request
    {
        TUid user;
        TUid createdBy;
        TOid objectId;
        std::vector<SpravTask::Status> statuses;
        Token token;
        size_t offset;
        size_t limit;
    };

    explicit GetSpravTasks(const Request& request);

    std::string printRequest() const override;

protected:
    void control() override;

private:
    const Request request_;
};

} // namespace maps::wiki
