#pragma once
#include "maps/wikimap/mapspro/services/editor/src/common.h"
#include "maps/wikimap/mapspro/services/editor/src/utils.h"

namespace maps
{
namespace wiki
{

//!Hotspot may contain many geometries for polygons
//! and polyline buffers holes support
class Hotspot
{
public:
    Hotspot(const TGeoPoint& corner, TOid id, const Geom& geom, TZoom zoom,
            unsigned int simplificationTolerance, double width,
            PolygonBufferPolicy polygonBufferPolicy);

    const TGeoPoint& corner() const
    { return corner_;}

    TOid objectId() const
    { return objectId_;}

    const std::list<Geom>& geoms() const
    { return geoms_;}

private:
    TGeoPoint corner_;
    TOid objectId_;
    std::list<Geom> geoms_;
};

typedef std::shared_ptr<Hotspot> HotspotPtr;

}//wiki
}//maps
