#include "tile_object.h"

#include "maps/wikimap/mapspro/services/editor/src/actions/magic_strings.h"
#include "maps/wikimap/mapspro/services/editor/src/srv_attrs/calc.h"
#include "maps/wikimap/mapspro/services/editor/src/srv_attrs/registry.h"
#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"
#include "maps/wikimap/mapspro/services/editor/src/configs/categories_strings.h"

#include <yandex/maps/wiki/configs/editor/category_template.h>
#include <yandex/maps/wiki/configs/editor/interactivity.h>
#include <yandex/maps/wiki/configs/editor/categories.h>
#include <maps/libs/tile/include/utils.h>

namespace maps {
namespace wiki {

namespace {
const std::string ID = "id";
const std::string COMMIT_ID = "commit_id";
const std::string THE_GEOM = "the_geom";
const std::string ATTRS = "attrs";
const std::string DOMAIN_ATTRS = "domain_attrs";
const std::string CAT_NAME_ERROR = "error";
const std::string CAT_NAME_AOI = CATEGORY_AOI;

std::string
calcLabel(const pqxx::row& properties, const std::string& categoryId)
{
    std::string label = properties["\"" + srv_attrs::SRV_HOTSPOT_LABEL + "\""].c_str();
    if (!label.empty()) {
        return label;
    }
    if (srv_attrs::CalcSrvAttrs::hasRealtimeHotSpotLabel(categoryId)) {
        return srv_attrs::CalcSrvAttrs::calcRealtimeHotSpotLabel(
            properties[ DOMAIN_ATTRS ].c_str(), categoryId);
    }
    if (categoryId == CAT_NAME_ERROR) {
        return srv_attrs::CalcSrvAttrs::calcErrorHotSpotLabel(properties[ DOMAIN_ATTRS ].c_str());
    }
    if (categoryId == CATEGORY_MERGE_REGION) {
        return srv_attrs::CalcSrvAttrs::calcMergeRegionHotSpotLabel(properties[ DOMAIN_ATTRS ].c_str());
    }
    if (!properties[FT_TYPE_ID].is_null()) {
        std::string ftTypeIdValue = properties[FT_TYPE_ID].c_str();
        if (!ftTypeIdValue.empty()) {
            return valueLabel(categoryId + ":" + FT_TYPE_ID, ftTypeIdValue);
        }
    }
    return s_emptyString;
}

} // namespace

TileObject::TileObject(
    const pqxx::row& properties,
    TZoom zoom,
    const StringSet& customFields,
    SimpificationPolicy simpificationPolicy)
    : revision_(properties[ ID ].as<TOid>(), properties[ COMMIT_ID ].as<TCommitId>())
    , simpificationPolicy_(simpificationPolicy)
{
    for (const auto& field : customFields) {
        customFieldsData_.insert({field, properties[field].c_str()});
    }
    const auto& propertyGeom = properties[ THE_GEOM ];
    ASSERT(!propertyGeom.is_null());
    geom_ = Geom(propertyGeom);

    categoryId_ = categoryFromAttributes(properties[ ATTRS ].c_str());
    label_ = calcLabel(properties, categoryId_);

    const auto& categoryTemplate =
        cfg()->editor()->categories()[categoryId_].categoryTemplate();

    const auto& interactivity =
        cfg()->editor()->interactivity(
            categoryTemplate.interactivityId());

    if (SimpificationPolicy::Simplify == simpificationPolicy_ &&
        geom_->getNumPoints() > interactivity.simplificationMinNumberPoints())
    {
        geom_.simplify(
            interactivity.geometrySimplificationTolerance() * tile::zoomToResolution(zoom));
    }
}

} // namespace wiki
} // namespace maps
