#pragma once
#include "hotspot.h"

#include <memory>
#include <string>

namespace maps::wiki {

class TileObject
{
public:
    enum class SimpificationPolicy {
        Simplify,
        KeepPrecise
    };

    TileObject(
        const pqxx::row& properties,
        TZoom zoom,
        const StringSet& customFields,
        SimpificationPolicy simpificationPolicy);

    TOid id() const { return revision_.objectId(); }

    TRevisionId revision() const { return revision_; }

    const Geom& geom() const { return geom_; }

    const std::string& label() const { return label_; }

    /**
    * Add hotspot and take ownership
    */
    void setHotspot(std::unique_ptr<Hotspot>&& h)
    {
        hotspot_ = std::move(h);
    }

    const std::string& categoryId() const { return categoryId_; }

    const StringMap& customFieldsData() const { return customFieldsData_; }

    const Hotspot& hotspot() const { return *hotspot_; }

    SimpificationPolicy simpificationPolicy() const { return simpificationPolicy_; }

private:
    TRevisionId revision_;

    std::string label_;

    std::string categoryId_;

    Geom geom_;

    StringMap customFieldsData_;

    std::unique_ptr<Hotspot> hotspot_;
    const SimpificationPolicy simpificationPolicy_;
};

} // namespace maps::wiki
