#pragma once

#include "maps/wikimap/mapspro/services/editor/src/common.h"
#include <yandex/maps/wiki/common/lrucache.h>

namespace maps::wiki {

using AttrIdValuePair = std::pair<std::string, std::string>;

class UserAclData
{
public:
    static UserAclData create(TUid uid, Transaction& workCore);
    StringSet filterRequestCategories(const StringSet& requestCategories) const;
    bool isAllowedObjectByAttributes(const StringMap& attributes) const;

private:
    UserAclData() = default;
    std::string dump() const;

    StringSet allowedCategories_;
    std::map<std::string, std::set<AttrIdValuePair>> categoriesToAllowedAttrIdValues_;
};

class UserAclDataCache
{
public:
    UserAclDataCache();
    UserAclData get(TUid uid, const Token& dbToken);

private:
    common::LRUCacheThreadSafe<TUid, UserAclData> cache_;
};

} // namespace maps::wiki
