#include "address_of_building.h"
#include "load_objects.h"

namespace maps::wiki::pedestrian {

std::optional<std::string>
getAddressOfBuilding(
    const geolib3::Polygon2& buildingPolygon,
    pqxx::transaction_base& viewTxn)
{
    auto addresses = loadBldLinkedObjects<Address>(
        buildingPolygon,
        viewTxn
    );

    auto addrIt = std::find_if(addresses.begin(), addresses.end(), [](const Address& addr){
        return addr.name != std::nullopt;
    });

    if (addrIt != addresses.end()) {
        return addrIt->name;
    };

    return std::nullopt;
}

} // namespace maps::wiki::pedestrian
