#pragma once

#include "model.h"
#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/static_geometry_searcher.h>
#include <vector>

namespace maps::wiki::pedestrian {

class AddressSearcher {
public:
    AddressSearcher(const std::vector<Address>& entrances);
    std::vector<Address> getBuildingAddresses(const Building& building) const;

private:
    const std::vector<Address>& addresses_;
    std::vector<geolib3::BoundingBox> addressBoxes_;
    geolib3::StaticGeometrySearcher<geolib3::BoundingBox, const Address*> searcher_;
};

} // namespace maps::wiki::pedestrian
