#include "buildings_for_tasks.h"
#include "entrance_searcher.h"
#include "address_searcher.h"

namespace maps::wiki::pedestrian {

template<>
std::vector<Building>
buildingsForTasks(
    const std::vector<Building>& buildings,
    const std::vector<Entrance>& entrances)
{
    const EntranceSearcher searcher(entrances);

    std::vector<Building> result;

    for (const auto& building : buildings) {
        const auto itsEntrances = searcher.getBuildingEntrances(building);

        size_t withoutNamesCount = std::count_if(
            itsEntrances.begin(), itsEntrances.end(),
            [](const auto& entrance) {
                return entrance.name == std::nullopt;
            }
        );

        if (itsEntrances.empty() || withoutNamesCount) {
            result.push_back(building);
        }
    }

    return result;
}

template<>
std::vector<Building>
buildingsForTasks(
    const std::vector<Building>& buildings,
    const std::vector<Address>& addresses)
{
    const AddressSearcher searcher(addresses);

    std::vector<Building> result;

    for (const auto& building : buildings) {
        if (searcher.getBuildingAddresses(building).empty()) {
            result.push_back(building);
        }
    }

    return result;
}

} // namespace maps::wiki::pedestrian
