#pragma once

#include "model.h"
#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/static_geometry_searcher.h>
#include <vector>

namespace maps::wiki::pedestrian {

class EntranceSearcher {
public:
    EntranceSearcher(const std::vector<Entrance>& entrances);
    std::vector<Entrance> getBuildingEntrances(const Building& building) const;

private:
    const std::vector<Entrance>& entrances_;
    std::vector<geolib3::BoundingBox> entranceBoxes_;
    geolib3::StaticGeometrySearcher<geolib3::BoundingBox, const Entrance*> searcher_;
};

} // namespace maps::wiki::pedestrian
