#pragma once

#include "model.h"
#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/common/include/exception.h>
#include <pqxx/pqxx>
#include <vector>

namespace maps::wiki::pedestrian {

struct ObjectsLimitException : RuntimeError {};

template<typename BldLinkedObject>
std::vector<Building> loadBuildings(
    const geolib3::Polygon2& polygonMerc,
    pqxx::transaction_base& viewTxn);

template<typename BldLinkedObject>
std::vector<BldLinkedObject> loadBldLinkedObjects(
    const geolib3::Polygon2& polygonMerc,
    pqxx::transaction_base& viewTxn);

} // namespace maps::wiki::pedestrian

#define WIKIMAP_EDITOR_PEDESTRIAN_LOAD_OBJECTS_TPL
#include "load_objects-impl.h"
#undef WIKIMAP_EDITOR_PEDESTRIAN_LOAD_OBJECTS_TPL
