#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polygon.h>
#include <optional>

namespace maps::wiki::pedestrian {

struct Building
{
    TId objectId;
    geolib3::Polygon2 polygonMerc;

    Building(TId objectId, geolib3::Polygon2 polygonMerc) :
        objectId(objectId), polygonMerc(std::move(polygonMerc))
    {}
};

struct PointNameObject
{
    TId objectId;
    geolib3::Point2 positionMerc;
    std::optional<std::string> name;

    PointNameObject(TId objectId, geolib3::Point2 positionMerc, std::optional<std::string> name) :
        objectId(objectId), positionMerc(positionMerc), name(std::move(name))
    {}
};

struct Entrance : PointNameObject
{
    using PointNameObject::PointNameObject;
};

struct Address : PointNameObject
{
    using PointNameObject::PointNameObject;
};

} // namespace maps::wiki::pedestrian
