#include "task_load_points.h"
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/geom.h>

#include <maps/wikimap/mapspro/libs/pedestrian_region/include/pedestrian_region.h>
#include <yandex/maps/wiki/common/geom.h>

namespace maps::wiki {

ToolsLoadPedestrianPoints::ToolsLoadPedestrianPoints(const Request& request)
    : controller::BaseController<ToolsLoadPedestrianPoints>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

std::string
ToolsLoadPedestrianPoints::printRequest() const
{
    std::stringstream ss;
    ss << " token: " << request_.token;
    ss << " oid: " << request_.oid;
    return ss.str();
}

void
ToolsLoadPedestrianPoints::control()
{
    auto& corePool = cfg()->poolCore();
    auto coreTxnHandle = corePool.slaveTransaction();

    auto region = pedestrian::regionById(coreTxnHandle.get(), request_.oid);
    if (region) {
        for (const auto& point : region->mercPoints()) {
            result_->points.emplace_back(pointToGeom(point));
        }
    }
}

} // namespace maps::wiki
