#include "task_save_points.h"
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>

#include <maps/wikimap/mapspro/libs/pedestrian_region/include/pedestrian_region.h>

namespace maps::wiki {

ToolsSavePedestrianPoints::ToolsSavePedestrianPoints(const Request& request)
    : controller::BaseController<ToolsSavePedestrianPoints>(BOOST_CURRENT_FUNCTION)
    , request_(request)
{
}

std::string
ToolsSavePedestrianPoints::printRequest() const
{
    std::stringstream ss;
    ss << " uid: " << request_.uid;
    ss << " oid: " << request_.oid;
    ss << " points: " << (json::Builder() << request_.points).str();
    return ss.str();
}

void
ToolsSavePedestrianPoints::control()
{
    auto& corePool = cfg()->poolCore();
    auto coreTxnHandle = corePool.masterWriteableTransaction();

    pedestrian::Region region(request_.oid, request_.points, request_.uid);
    pedestrian::upsertRegion(coreTxnHandle.get(), region);
    result_->token = pgpool3::generateToken(*coreTxnHandle);
    coreTxnHandle.get().commit();
}

} // namespace maps::wiki
