#pragma once

#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>
#include "poi_conflicts_common.h"
#include "maps/wikimap/mapspro/services/editor/src/views/view_object.h"

#include <maps/wikimap/mapspro/libs/poi_conflicts/include/poi_conflicts.h>
#include <yandex/maps/wiki/filters/common.h>

#include <map>
#include <optional>

namespace maps::wiki {

class ToolsResolvePoisConflicts;
template<>
struct controller::ResultType<ToolsResolvePoisConflicts>
{
    std::map<TOid, Geom> movedPois;
};


class ToolsResolvePoisConflicts : public controller::BaseController<ToolsResolvePoisConflicts>
{
public:
    struct Request
    {
        std::string dump() const;
        Token dbToken;
        TBranchId branchId;
        std::string requestBody;
        TUid uid;
    };

    explicit ToolsResolvePoisConflicts(const Request& request);

    virtual std::string printRequest() const;
    static const std::string& taskName();

protected:
    virtual void control();

    Request request_;
};

} // namespace maps::wiki
