#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

namespace maps::wiki {

class ToolsResolvePoisConflictsMeta;

template<>
struct controller::ResultType<ToolsResolvePoisConflictsMeta>
{
    StringSet categoryIds;
    size_t maxObjects = 0;
};

class ToolsResolvePoisConflictsMeta
    : public controller::BaseController<ToolsResolvePoisConflictsMeta>
{
public:
    struct Request
    {
        std::string dump() const;

        TUid uid;
    };

    explicit ToolsResolvePoisConflictsMeta(const Request& request);

    virtual ~ToolsResolvePoisConflictsMeta() = default;

    static const std::string& taskName();

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    Request request_;
};

} // namespace maps::wiki
