#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <yandex/maps/wiki/common/before_after.h>
#include <yandex/maps/wiki/validator/storage/exclusions_gateway.h>

namespace maps::wiki {

struct ValidationStatsNode
{
    std::string field;
    std::string value;
    size_t count;
    std::vector<ValidationStatsNode> children;
};

class GetValidationExclusions;
template<>
struct controller::ResultType<GetValidationExclusions>
{
    validator::storage::StoredMessageData exclusions;
    size_t totalCount;
    std::vector<ValidationStatsNode> regionTypeStats;
    std::vector<ValidationStatsNode> severityStats;
    std::vector<ValidationStatsNode> checkStats;
    TUid uid;
    size_t page;
    size_t perPage;
    std::optional<bool> hasMore;
};

class GetValidationExclusions : public controller::BaseController<GetValidationExclusions>
{
public:
    struct Request
    {
        const TUid uid;
        const TBranchId branchId;

        const boost::optional<validator::Severity> severity;
        const boost::optional<validator::TCheckId> checkId;
        const boost::optional<std::string> description;
        const boost::optional<validator::RegionType> regionType;
        const boost::optional<TUid> createdBy;
        const boost::optional<bool> viewed;
        const boost::optional<std::string> bboxStr;

        const size_t page;
        const size_t perPage;

        validator::storage::MessageId startId;
        common::BeforeAfter beforeAfter;
        size_t limit;

        const Token token;
    };

    explicit GetValidationExclusions(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    std::vector<ValidationStatsNode>
    regionTypeStatsNodes(const validator::storage::MessageStatistics& statistics);

    std::vector<ValidationStatsNode>
    severityStatsNodes(const validator::storage::MessageStatistics& statistics);

    std::vector<ValidationStatsNode>
    checkStatsNodes(const validator::storage::MessageStatistics& statistics);

private:
    const Request request_;

};

} // namespace maps::wiki
