#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <yandex/maps/wiki/validator/storage/exclusions_gateway.h>

namespace maps::wiki {

class SaveValidationExclusion;
template<>
struct controller::ResultType<SaveValidationExclusion>
{
    TUid uid;
    std::unique_ptr<validator::storage::StoredMessageDatum> exclusion;
};

class SaveValidationExclusion : public controller::BaseController<SaveValidationExclusion>
{
public:
    enum class Op
    {
        Add,
        Remove,
    };

    struct Request
    {
        const TUid uid;
        const TBranchId branchId;
        const validator::storage::MessageId messageId;
        Op operation;
    };

    explicit SaveValidationExclusion(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace maps::wiki
