#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/libs/controller/include/basecontroller.h>

#include <yandex/maps/wiki/validator/storage/exclusions_gateway.h>

namespace maps::wiki {

class ViewValidationExclusion;
template<>
struct controller::ResultType<ViewValidationExclusion>
{
    TUid uid;
    std::unique_ptr<validator::storage::StoredMessageDatum> exclusion;
};

class ViewValidationExclusion : public controller::BaseController<ViewValidationExclusion>
{
public:
    struct Request
    {
        const TUid uid;
        const TBranchId branchId;
        const validator::storage::MessageId messageId;
    };

    explicit ViewValidationExclusion(const Request& request);

    virtual std::string printRequest() const;

protected:
    virtual void control();

private:
    const Request request_;
};

} // namespace maps::wiki
