#include "handles.h"

namespace editor = maps::wiki;

namespace {

yacare::ThreadPool branchesThreadPool("branches", 2, 20);

} // namespace

YCR_USE(branchesThreadPool) {

YCR_RESPOND_TO("GET /branches", uid = NO_UID, token = "")
{
    editor::GetBranches::Request controllerRequest = {uid, token};
    handleController<editor::GetBranches>(response, controllerRequest, requestedFormat(request));
}

//DEPRECATED
YCR_RESPOND_TO("POST /branches/$", uid)
{
    editor::ControllerAsync<editor::SaveBranchType> controller(
        editor::observers(),
        {
            uid,
            getParam<std::string>(request, "type"), // branchType
            getParam<editor::TBranchId>(argv, 0)
        },
        requestedFormat(request));
    handleController(response, controller, requestedFormat(request));
}

YCR_RESPOND_TO("POST /branches/$/type/$", uid)
{
    editor::ControllerAsync<editor::SaveBranchType> controller(
        editor::observers(),
        {
            uid,
            getParam<std::string>(argv, 1), // branchType
            getParam<editor::TBranchId>(argv, 0)
        },
        requestedFormat(request));
    handleController(response, controller, requestedFormat(request));
}

YCR_RESPOND_TO("POST /branches/$/state/$", uid)
{
    editor::ControllerAsync<editor::SaveBranchState> controller(
        editor::observers(),
        {
            uid,
            getParam<editor::revision::BranchState>(argv, 1),
            getParam<editor::TBranchId>(argv, 0)
        },
        requestedFormat(request));
    handleController(response, controller, requestedFormat(request));
}

} // YCR_USE
