#include "handles.h"

#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/moderation_log.h>


YCR_RESPOND_TO("POST /logrotate/moderation", YCR_RESTRICT_TO_LOCAL)
{
    if (maps::wiki::cfg()->moderationLogger()) {
        maps::wiki::cfg()->moderationLogger()->onLogrotate();
    }
}

YCR_RESPOND_TO("POST /logrotate/comments", YCR_RESTRICT_TO_LOCAL)
{
    if (maps::wiki::cfg()->commentsLogger()) {
        maps::wiki::cfg()->commentsLogger()->onLogrotate();
    }
}

YCR_NGINX_LOCATION("= /config.tgz", R"(
    root /usr/share/yandex/maps/wiki/editor-export;
    default_type application/x-tgz;
)")
