#include "handles.h"

namespace common = maps::wiki::common;
namespace editor = maps::wiki;

namespace {
yacare::ThreadPool filtersThreadPool("filters", 2, 20);
} // namespace

YCR_USE(filtersThreadPool) {

YCR_RESPOND_TO("GET /filters",
        uid,
        startId,
        beforeAfter,
        limit,
        namePart,
        token = "")
{
    editor::GetFilters::Request controllerRequest {
        uid,
        getOptionalParam<editor::TUid>(request, "created-by"),
        getParam<size_t>(request, "page", 1),
        getParam<size_t>(request, "per-page", 10),
        beforeAfter,
        startId,
        limit,
        namePart,
        token
    };
    handleController<editor::GetFilters>(response, controllerRequest, requestedFormat(request));

}

YCR_RESPOND_TO("POST /filters", uid)
{
    editor::SaveFilter::Request controllerRequest {
        uid,
        0, // new filter id
        getParam<std::string>(request, "name"),
        getParam<bool>(request, "public", false),
        getParam<std::string>(request, "expression")
    };
    handleController<editor::SaveFilter>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("POST /filters/$", uid)
{
    editor::SaveFilter::Request req {
        uid,
        getParam<editor::filters::TFilterId>(argv, 0),
        getParam<std::string>(request, "name"),
        getParam<bool>(request, "public"),
        getParam<std::string>(request, "expression")
    };
    handleController<editor::SaveFilter>(response, req, requestedFormat(request));
}

YCR_RESPOND_TO("DELETE /filters/$", uid)
{
    editor::DeleteFilter::Request controllerRequest {
        uid,
        getParam<editor::filters::TFilterId>(argv, 0)
    };
    handleController<editor::DeleteFilter>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("GET /filters/expressions/$", token = "")
{
    editor::GetFilterExpression::Request controllerRequest {
        getParam<editor::filters::TExpressionId>(argv, 0),
        getParam<std::string>(request, "format", std::string()), // Request descritpion or SQL
        token
    };
    handleController<editor::GetFilterExpression>(response, controllerRequest, common::FormatType::XML);
}

YCR_RESPOND_TO("POST /filters/expressions", uid)
{
    editor::SaveExpression::Request controllerRequest{
            uid,
            getParam<std::string>(request, "expression")};
    handleController<editor::SaveExpression>(response, controllerRequest, requestedFormat(request));
}

} // YCR_USE
