#include "handles.h"

namespace editor = maps::wiki;

namespace {
yacare::ThreadPool geolocksThreadPool("geolocks", 5, 50);
} // namespace

YCR_USE(geolocksThreadPool) {

YCR_RESPOND_TO("GET /geolocks",
               uid, branch = TRUNK_BRANCH_ID)
{
    editor::GetGeoLocks::Request controllerRequest{
            uid,
            branch,
            getParam<std::string>(request, "bb"),
    };
    handleController<editor::GetGeoLocks>(response, controllerRequest, requestedFormat(request));
}

} // YCR_USE
