#include "handles.h"

#include <maps/wikimap/mapspro/services/editor/src/serialize/get_suggest_parser.h>

namespace editor = maps::wiki;

namespace {

yacare::ThreadPool suggestThreadPool("suggest", 4, 40);

editor::GetSuggest::Request
createSuggestRequest(
    const yacare::Request& request,
    editor::TBranchId branch,
    const std::string& token)
{
    editor::GetSuggest::Request controllerRequest
        {
            {},
            getParam<std::string>(request, "text", ""),
            getParam<size_t>(request, "limit", 0),
            getParam<std::string>(request, "ll", ""),
            token,
            branch,
            getParam<double>(request, "d", .0),
            {},
            getParam<editor::GetSuggest::GeomPredicate>(request, "predicate", editor::GetSuggest::GeomPredicate::Distance),
            {},
            getParam<std::string>(request, "lang", "")
        };
    return controllerRequest;
}

} // namespace

YCR_USE(suggestThreadPool) {

YCR_RESPOND_TO("GET /suggest/$", branch = TRUNK_BRANCH_ID, token = "")
{
    auto controllerRequest = createSuggestRequest(request, branch, token);
    controllerRequest.categories = getParam<std::string>(argv, 0);
    controllerRequest.geometry = request.input().has("geometry")
            ? maps::wiki::common::Geom(editor::createGeomFromJsonStr(request.input()["geometry"]))
            : maps::wiki::common::Geom();
    handleController<editor::GetSuggest>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("GET /suggest", branch = TRUNK_BRANCH_ID, token = "")
{
    auto controllerRequest = createSuggestRequest(request, branch, token);
    controllerRequest.categories = getParam<std::string>(request, "categories", "");
    controllerRequest.geometry = request.input().has("geometry")
            ? maps::wiki::common::Geom(editor::createGeomFromJsonStr(request.input()["geometry"]))
            : maps::wiki::common::Geom();
    handleController<editor::GetSuggest>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("POST /suggest", branch = TRUNK_BRANCH_ID, token = "")
{
    auto controllerRequest = createSuggestRequest(request, branch, token);
    editor::GetSuggestParser parser;
    parser.parse(requestedFormat(request), request.body());
    controllerRequest.categories = getParam<std::string>(request, "categories", "");
    controllerRequest.geometry = parser.geometry();
    controllerRequest.parsedAttributesAndValues = parser.attributesValues();
    handleController<editor::GetSuggest>(response, controllerRequest, requestedFormat(request));
}

} // YCR_USE
