#include "handles.h"

namespace editor = maps::wiki;

namespace {

yacare::ThreadPool tileThreadPool("tile", 10, 100);

const double HOTSPOT_WIDTH_MIN = 1.0;
const double HOTSPOT_WIDTH_MAX = 50.0;

} // namespace

YCR_USE(tileThreadPool) {

YCR_RESPOND_TO("GET /tile/$/$/$/objects", uid, branch = TRUNK_BRANCH_ID, token = "")
{
    bool isSnapModeRequest = request.input().has("hotspot-width");
    std::optional<double> hotspotWidth {
        isSnapModeRequest
            ? getParam<double>(request, "hotspot-width")
            : std::optional<double>()
    };

    WIKI_REQUIRE(!hotspotWidth || (
            *hotspotWidth >  HOTSPOT_WIDTH_MIN &&
            *hotspotWidth <  HOTSPOT_WIDTH_MAX), editor::ERR_BAD_REQUEST,
        "hotspot-width parameter out of range.");
    editor::GetObjectsByTile::Request controllerRequest {
        getParam<unsigned int>(argv, 0),
        getParam<unsigned int>(argv, 1),
        getParam<editor::TZoom>(argv, 2),
        uid,
        token,
        branch,
        request.input().has("categories")
            ? getParam<std::string>(request, "categories", "")
            : std::optional<std::string>(),
        hotspotWidth,
        getParam<editor::TOid>(request, "object-id", 0),
        isSnapModeRequest
            ? editor::PolygonBufferPolicy::Rings
            : editor::PolygonBufferPolicy::Self,
        getParam<bool>(request, "dead-ends", true),
        getParam<bool>(request, "ignore-zmax", false)
            ? editor::GetObjectsByTile::ZMaxPolicy::Ignore
            : editor::GetObjectsByTile::ZMaxPolicy::Compare,
        getParam<bool>(request, "ignore-zmin", false)
            ? editor::GetObjectsByTile::ZMinPolicy::Ignore
            : editor::GetObjectsByTile::ZMinPolicy::Compare,
        getParam<bool>(request, "simplify", true)
            ? editor::TileObject::SimpificationPolicy::Simplify
            : editor::TileObject::SimpificationPolicy::KeepPrecise,
        getParam<editor::TOid>(request, "indoor-level-id", 0),
        getStdOptionalParam<maps::wiki::filters::TExpressionId>(request, "expression-id"),
        };
    handleController<editor::GetObjectsByTile>(response, controllerRequest, requestedFormat(request));
}

} // YCR_USE
