#include "handles.h"

#include <maps/wikimap/mapspro/services/editor/src/serialize/get_route_time_parser.h>

namespace editor = maps::wiki;

namespace {

yacare::ThreadPool toolsThreadPool("tools", 3, 30);

} // namespace

// added extra strange strings to fix linker error:
// ld: error: duplicate symbol: YcrImplUseNamespace_13::yacare_inherited_options()
YCR_USE(toolsThreadPool) {

YCR_RESPOND_TO("POST /tools/resolve-pois-conflicts",
    branch = TRUNK_BRANCH_ID,
    token = "",
    uid = NO_UID)
{
    editor::ToolsResolvePoisConflicts::Request controllerRequest {
        token,
        branch,
        request.body(),
        uid
    };
    handleController<editor::ToolsResolvePoisConflicts>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("GET /tools/resolve-pois-conflicts/meta",
    uid = NO_UID)
{
    editor::ToolsResolvePoisConflictsMeta::Request controllerRequest {
        uid
    };
    handleController<editor::ToolsResolvePoisConflictsMeta>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("POST /tools/route-time",
    uid = NO_UID,
    branch = TRUNK_BRANCH_ID,
    token = "",
    sync = false)
{
    editor::GetRouteTimeParser parser;
    parser.parse(requestedFormat(request), request.body());

    editor::GetRouteTime::Request controllerRequest{
        uid,
        token,
        branch,
        parser.revisionId(),
        parser.categoryId(),
        parser.addElementIds(),
        parser.removeElementIds(),
        parser.threadStopSequence()
    };

    handleController<editor::GetRouteTime>(
        response,
        sync,
        controllerRequest,
        requestedFormat(request)
    );
}

YCR_RESPOND_TO("GET /tools/pedestrian_points", token = "")
{
    editor::ToolsPedestrianPoints::Request controllerRequest {
        token,
        getParam<editor::TOid>(request, "oid"),
    };
    handleController<editor::ToolsPedestrianPoints>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("POST /tools/save_pedestrian_points", uid)
{
    editor::ToolsSavePedestrianPoints::Request controllerRequest {
        getParam<editor::TOid>(request, "oid"),
        uid,
        maps::json::Value::fromString(request.input()["points"])
    };
    handleController<editor::ToolsSavePedestrianPoints>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("GET /tools/load_pedestrian_points", token = "")
{
    editor::ToolsLoadPedestrianPoints::Request controllerRequest {
        token,
        getParam<editor::TOid>(request, "oid"),
    };
    handleController<editor::ToolsLoadPedestrianPoints>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("GET /tools/business-photos/$",
            uid = NO_UID,
            branch = TRUNK_BRANCH_ID,
            token = "")
{
    editor::BusinessPhotos::Request controllerRequest =
        {
            getParam<std::string>(argv, 0),
            uid
        };
    handleController<editor::BusinessPhotos>(
        response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("POST /tools/distribute-flats", branch = TRUNK_BRANCH_ID, token = "")
{
    editor::DistributeFlats::Request controllerRequest =
        {
            request.body()
        };
    handleController<editor::DistributeFlats>(
        response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("GET /tools/point-to-bld", branch = TRUNK_BRANCH_ID, token = "")
{
    editor::PointToBld::Request controllerRequest =
        {
            getParam<std::string>(request, "point"),
            getParam<std::string>(request, "bld-number", ""),
            branch,
            token
        };
    handleController<editor::PointToBld>(
        response, controllerRequest, requestedFormat(request));
}

} // YCR_USE
