#include "handles.h"

namespace editor = maps::wiki;
namespace mwv = maps::wiki::validator;

namespace {

yacare::ThreadPool validationThreadPool("validation", 2, 20);

} // namespace

YCR_USE(validationThreadPool) {

YCR_RESPOND_TO("GET /validation/exclusions",
               uid,
               startMessageId,
               beforeAfter,
               limit,
               branch = TRUNK_BRANCH_ID,
               token = "")
{
    editor::GetValidationExclusions::Request controllerRequest{
        uid,
        branch,
        getOptionalParam<mwv::Severity>(request, "severity"),
        getOptionalParam<mwv::TCheckId>(request, "check"),
        getOptionalParam<std::string>(request, "description"),
        getOptionalParam<mwv::RegionType>(request, "region-type"),
        getOptionalParam<editor::TUid>(request, "created-by"),
        getOptionalParam<bool>(request, "viewed"),
        getOptionalParam<std::string>(request, "bb"),
        getParam<size_t>(request, "page", 1),
        getParam<size_t>(request, "per-page", 10),
        startMessageId,
        beforeAfter,
        limit,
        token};
    handleController<editor::GetValidationExclusions>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("POST /validation/messages/$/exclusion",
               uid, branch = TRUNK_BRANCH_ID)
{
    editor::SaveValidationExclusion::Request controllerRequest{
            uid,
            branch,
            getParam<mwv::storage::MessageId>(argv, 0),
            editor::SaveValidationExclusion::Op::Add};
    handleController<editor::SaveValidationExclusion>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("DELETE /validation/messages/$/exclusion",
               uid, branch = TRUNK_BRANCH_ID)
{
    editor::SaveValidationExclusion::Request controllerRequest{
            uid,
            branch,
            getParam<mwv::storage::MessageId>(argv, 0),
            editor::SaveValidationExclusion::Op::Remove};
    handleController<editor::SaveValidationExclusion>(response, controllerRequest, requestedFormat(request));
}

YCR_RESPOND_TO("POST /validation/messages/$/exclusion/view",
               uid, branch = TRUNK_BRANCH_ID)
{
    editor::ViewValidationExclusion::Request controllerRequest{
            uid,
            branch,
            getParam<mwv::storage::MessageId>(argv, 0)};
    handleController<editor::ViewValidationExclusion>(response, controllerRequest, requestedFormat(request));
}

} // YCR_USE
