#include "observers.h"

#include <maps/wikimap/mapspro/services/editor/src/observers/category_specific.h>
#include <maps/wikimap/mapspro/services/editor/src/observers/renderer.h>
#include <maps/wikimap/mapspro/services/editor/src/observers/social.h>
#include <maps/wikimap/mapspro/services/editor/src/observers/sprav_poi_signal.h>
#include <maps/wikimap/mapspro/services/editor/src/observers/feedback_task_binder.h>
#include <maps/wikimap/mapspro/services/editor/src/observers/revision_meta_queue.h>
#include <maps/wikimap/mapspro/services/editor/src/observers/view_syncronizer.h>

namespace maps::wiki {

static ObserverCollection s_observers;

const ObserverCollection& observers()
{
    return s_observers;
}

void
initObservers()
{
    INFO() << BOOST_CURRENT_FUNCTION << " Registering view syncronizer";
    s_observers.add(ObserverPtr(new ViewSyncronizer()));

    INFO() << BOOST_CURRENT_FUNCTION << " Registering labeler";
    s_observers.add(ObserverPtr(new RendererObserver()));

    INFO() << BOOST_CURRENT_FUNCTION << " Registering social observer";
    s_observers.add(ObserverPtr(new SocialObserver()));

    INFO() << BOOST_CURRENT_FUNCTION << " Registering feedback task binder";
    s_observers.add(ObserverPtr(new FeedbackTaskBinder()));

    INFO() << BOOST_CURRENT_FUNCTION << " Registering category specific observer";
    s_observers.add(ObserverPtr(new CategorySpecificObserver()));

    INFO() << BOOST_CURRENT_FUNCTION << " Registering revision meta queue observer";
    s_observers.add(ObserverPtr(new RevisionMetaQueue()));

    INFO() << BOOST_CURRENT_FUNCTION << " Registering sprav poi observer";
    s_observers.add(ObserverPtr(new SpravPoiObserver()));
}

} // namespace maps::wiki
