#pragma once

#include "branch_helpers.h"
#include <yandex/maps/wiki/social/feed.h>
#include <yandex/maps/wiki/social/task.h>
#include <yandex/maps/wiki/revision/commit.h>

#include <iosfwd>
#include <list>

namespace maps {
namespace wiki {
namespace approve_status {

enum class ApproveStatus
{
    Pending,
    Approved,
    Rejected,
    Published
};

std::ostream& operator << (std::ostream& os, const ApproveStatus& status);
std::istream& operator >> (std::istream& is, ApproveStatus& status);


std::map<TCommitId, ApproveStatus>
evalApproveStatuses(const BranchContext& branchCtx, const std::list<revision::Commit>& commits);

ApproveStatus
evalApproveStatus(const BranchContext& branchCtx, const revision::Commit& commit);

// expected that
// 1) event.size() == commits.size()
// 2) each event in events should refer to some commit in commits
std::map<social::TId, ApproveStatus>
evalEventsApproveStatuses(
    const BranchContext& branchCtx,
    const social::Events& events,
    const std::list<revision::Commit>& commits);

} // namespace approve_status
} // namespace wiki
} // namespace maps
