#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <yandex/maps/wiki/social/task.h>
#include <yandex/maps/wiki/social/moderation.h>
#include <maps/wikimap/mapspro/libs/acl/include/user.h>

namespace maps {
namespace wiki {

class BranchContext;

namespace approved_commits {

class CommitsApprover
{
public:
    CommitsApprover(
        const BranchContext& branchCtx,
        const acl::User& user,
        TCommitIds commitIds);

    const TCommitIds& commitIds() const { return commitIds_; }

    social::TaskIds closeTasks(social::CloseResolution closeResolution) const;
    social::TaskIds closeTasksWithContributing(social::CloseResolution closeResolution) const;
    social::TaskIds closeTasksWithContributing(TUid closeBy, social::CloseResolution closeResolution) const;

    void awakeUpdater() const;

private:
    const BranchContext& branchCtx_;
    const TUid uid_;

    TCommitIds commitIds_;
};

} // namespace approved_commits
} // namespace wiki
} // namespace maps
