#pragma once

#include <maps/wikimap/mapspro/libs/revision_meta/include/approved_queue.h>

#include <maps/wikimap/mapspro/services/editor/src/execution_state.h>
#include <maps/wikimap/mapspro/services/editor/src/sync/db_helpers.h>
#include <maps/wikimap/mapspro/services/editor/src/sync/sync_objects.h>

namespace maps {
namespace wiki {
namespace approved_commits {

class Processor
{
public:
    Processor(
        sync::BranchLocker& branchLocker,
        const revision::Branch& approvedBranch,
        size_t threads,
        size_t commitRangeBatchSize);

    bool tryProcess(
        revision_meta::ApprovedQueueMode mode,
        const ExecutionStatePtr& executionState) const;

    //branch must be in a progress mode
    //throws exception if failed
    void waitAndProcess(revision_meta::ApprovedQueueMode mode) const;

private:
    sync::SyncParams prepareSyncParams(
        revision_meta::ApprovedQueueMode mode,
        const ExecutionStatePtr& executionState) const;

    sync::BranchLocker& branchLocker_;
    revision::Branch approvedBranch_;
    size_t threads_;
    size_t commitRangeBatchSize_;
};

} // namespace approved_commits
} // namespace wiki
} // namespace maps
