#pragma once

#include <yandex/maps/wiki/threadutils/thread_observer.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <mutex>

namespace maps::wiki {

enum class MonitoringState
{
    Ok,
    Warn,
    Crit
};

class HangingQueriesMonitoringState
{
public:
    bool isWarning(const std::string& poolName) const;
    bool isCritical(const std::string& poolName) const;
    const std::string& message(const std::string& poolName) const;

    void setPoolState(
        const std::string& poolName,
        MonitoringState state,
        std::string message);

private:
    mutable std::mutex mutex_;

    struct PoolInfo
    {
        MonitoringState state;
        std::string message;
    };

    std::unordered_map<std::string, PoolInfo> poolInfos_;
};

HangingQueriesMonitoringState& getMonitoringState();

class HangingQueriesMonitor: public ThreadObserver<HangingQueriesMonitor>
{
public:
    HangingQueriesMonitor();
    ~HangingQueriesMonitor();

private:
    friend class ThreadObserver<HangingQueriesMonitor>;
    const std::string& name() const;
    void onStart();
    void onStop();
    void doWork();

    void checkPool(const std::string& poolName, pgpool3::Pool& pool);
};

std::unique_ptr<HangingQueriesMonitor> createDbMonitor();

} // namespace maps::wiki
