#include <maps/wikimap/mapspro/services/editor/src/configs/pool_sections.h>
#include "db_monitor.h"

#include <maps/infra/yacare/include/yacare.h>

namespace maps::wiki {

namespace {
const std::string ALERT_PREFIX = "hanging-queries-";
} // namespace

#define ADD_DB_MONITORING(poolSectionName) \
YCR_WARN_IF( \
    getMonitoringState().isWarning(poolSectionName), \
    ALERT_PREFIX + poolSectionName, \
    getMonitoringState().message(poolSectionName)); \
\
YCR_ALERT_IF( \
    getMonitoringState().isCritical(poolSectionName), \
    ALERT_PREFIX + poolSectionName, \
    getMonitoringState().message(poolSectionName));

ADD_DB_MONITORING(POOL_SECTION_NAME_CORE)
ADD_DB_MONITORING(POOL_SECTION_NAME_SOCIAL)
ADD_DB_MONITORING(POOL_SECTION_NAME_VALIDATION)
ADD_DB_MONITORING(POOL_SECTION_NAME_VIEW_TRUNK)
ADD_DB_MONITORING(POOL_SECTION_NAME_VIEW_STABLE)
ADD_DB_MONITORING(POOL_SECTION_NAME_LABELS_TRUNK)
ADD_DB_MONITORING(POOL_SECTION_NAME_LABELS_STABLE)

} // namespace maps::wiki
