#include "deleted_users_cache_updater.h"

#include <chrono>

namespace maps::wiki {

namespace {
const std::string WORKER_NAME = "deleted users cache updater";
const std::chrono::seconds WAIT_TIMEOUT(60);
} // namespace


DeletedUsersCacheUpdater::DeletedUsersCacheUpdater(
    pgpool3::Pool& pgpool,
    acl::DeletedUsersCache& deletedUsersCache
)
    : ThreadObserver<DeletedUsersCacheUpdater>(WAIT_TIMEOUT)
    , pgpool_(pgpool)
    , deletedUsersCache_(deletedUsersCache)
{
    start();
}

constexpr const std::string& DeletedUsersCacheUpdater::name() const noexcept
{
    return WORKER_NAME;
}

void DeletedUsersCacheUpdater::onStart()
{
    INFO() << name() << " started";
}

void DeletedUsersCacheUpdater::onStop()
{
    INFO() << name() << " stopped";
}

void DeletedUsersCacheUpdater::doWork()
{
    auto txnHandle = pgpool_.slaveTransaction();
    deletedUsersCache_.update(*txnHandle);
}

} // namespace maps::wiki
