#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <yandex/maps/wiki/threadutils/thread_observer.h>

#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/libs/acl/include/deleted_users_cache.h>

namespace maps::wiki {

class DeletedUsersCacheUpdater : public ThreadObserver<DeletedUsersCacheUpdater> {
public:
    DeletedUsersCacheUpdater(
        pgpool3::Pool& pgpool,
        acl::DeletedUsersCache& deletedUsersCache);

private:
    friend class ThreadObserver<DeletedUsersCacheUpdater>;
    constexpr const std::string& name() const noexcept;
    void onStart();
    void doWork();
    void onStop();

    pgpool3::Pool& pgpool_;
    acl::DeletedUsersCache& deletedUsersCache_;
};

} // namespace maps::wiki
