#include "monitoring.h"

#include <maps/libs/pgpool/include/pool_configuration.h>


namespace maps {
namespace wiki {

namespace {

struct StateFormatter {
    const pgpool3::PoolState& state;
};

size_t
inUseByInstance(const pgpool3::InstanceId& ii, const pgpool3::PoolState& state)
{
    auto conCountIt = state.connectionsCount.find(ii);
    return
        conCountIt == state.connectionsCount.end()
        ? 0
        : conCountIt->second.inUse;
}

std::ostream& operator<<(std::ostream& s, StateFormatter sf)
{
    if (sf.state.configuration.master()) {
        auto master = *sf.state.configuration.master();
        s << "M|" << toString(master) << "|";
        auto inUse = inUseByInstance(master, sf.state);
        if (inUse == sf.state.constants.masterMaxSize) {
            s << "FULL (" << inUse << ")";
        } else if (inUse > sf.state.constants.masterSize) {
            s << "OVER (" << inUse << ")";
        } else {
            s << inUse;
        }
    }
    if (!sf.state.configuration.slaves().empty()) {
        for (auto ii: sf.state.configuration.slaves()) {
            s << " S|" << toString(ii) << "|";
            auto inUse = inUseByInstance(ii, sf.state);
            if (inUse == sf.state.constants.slaveMaxSize) {
                s << "FULL (" << inUse << ")";
            } else if (inUse > sf.state.constants.slaveSize) {
                s << "OVER (" << inUse << ")";
            } else {
                s << inUse;
            }
        }
    }
    return s;
}

}

Monitoring::Monitoring(
    const pgpool3::Pool& pgpool,
    std::string alias,
    std::chrono::seconds waitTimeout
)
    : ThreadObserver<Monitoring>(waitTimeout)
    , pgpool_(pgpool)
    , alias_(std::move(alias))
{
    start();
}

void
Monitoring::onStart()
{
    INFO() << name() << " STARTED";
}

void
Monitoring::onStop()
{
    INFO() << name() << " STOPPED";
}

void
Monitoring::doWork()
{
    INFO() << name() << " " << StateFormatter{pgpool_.state()};
}

} // namespace wiki
} // namespace maps
