#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <yandex/maps/wiki/threadutils/thread_observer.h>

#include <maps/libs/pgpool/include/pgpool3.h>

#include <chrono>

namespace maps {
namespace wiki {

class Monitoring: public ThreadObserver<Monitoring>
{
public:
    Monitoring(
        const pgpool3::Pool& pgpool,
        std::string alias,
        std::chrono::seconds waitTimeout);

private:
    friend class ThreadObserver<Monitoring>;
    std::string name() const { return "MONITORING(" + alias_ + ")"; }
    void onStart();
    void doWork();
    void onStop();

    const pgpool3::Pool& pgpool_;
    const std::string alias_;
};

} // namespace wiki
} // namespace maps
