#pragma once

#include <maps/wikimap/mapspro/services/editor/src/sprav/sprav_task.h>
#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <yandex/maps/wiki/threadutils/thread_observer.h>

#include <yandex/maps/wiki/common/pg_advisory_lock_ids.h>
#include <maps/libs/pgpool/include/pgpool3.h>

#include <chrono>
#include <string>

namespace maps::wiki {

class SpravTasksUpdater : public ThreadObserver<SpravTasksUpdater> {
public:
    SpravTasksUpdater(
        pgpool3::Pool& pgpool,
        std::chrono::seconds waitTimeout,
        SpravTask::Status statusToProcess,
        common::AdvisoryLockIds lockId);

private:
    std::string logHeader() const;
    friend class ThreadObserver<SpravTasksUpdater>;
    constexpr const std::string& name() const noexcept;
    void onStart();
    void doWork();
    void onStop();

    pgpool3::Pool& socialPool_;
    const SpravTask::Status statusToProcess_;
    const common::AdvisoryLockIds lockId_;
};

} // namespace maps::wiki
