#include "suspicious_users_table_cleaner.h"

#include <maps/libs/log8/include/log8.h>
#include <maps/libs/pgpool/include/pool_configuration.h>
#include <yandex/maps/wiki/social/gateway.h>


namespace maps {
namespace wiki {

namespace {
const std::string WORKER_NAME = "suspicious users table cleaner";
} // namespace


SuspiciousUsersTableCleaner::SuspiciousUsersTableCleaner(
    pgpool3::Pool& pgpool, std::chrono::seconds waitTimeout
)
    : ThreadObserver<SuspiciousUsersTableCleaner>(waitTimeout)
    , pgpool_(pgpool)
{
    start();
}


constexpr const std::string&
SuspiciousUsersTableCleaner::name() const noexcept
{
    return WORKER_NAME;
}


void
SuspiciousUsersTableCleaner::onStart()
{
    INFO() << name() << " started";
}


void
SuspiciousUsersTableCleaner::onStop()
{
    INFO() << name() << " stopped";
}


void
SuspiciousUsersTableCleaner::doWork()
{
    auto txnHandle = pgpool_.masterWriteableTransaction();
    social::Gateway(*txnHandle).removeOldSuspiciousUsers();
    txnHandle->commit();
}

} // namespace wiki
} // namespace maps
