#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <yandex/maps/wiki/threadutils/thread_observer.h>

#include <maps/libs/pgpool/include/pgpool3.h>

#include <chrono>
#include <string>

namespace maps {
namespace wiki {

class SuspiciousUsersTableCleaner: public ThreadObserver<SuspiciousUsersTableCleaner> {
public:
    SuspiciousUsersTableCleaner(pgpool3::Pool& pgpool, std::chrono::seconds waitTimeout);

private:
    friend class ThreadObserver<SuspiciousUsersTableCleaner>;
    constexpr const std::string& name() const noexcept;
    void onStart();
    void doWork();
    void onStop();

    pgpool3::Pool& pgpool_;
};

} // namespace wiki
} // namespace maps
