#include "check_outsource_consistency.h"

#include "objects_cache.h"
#include "configs/categories_strings.h"
#include "objects/areal_object.h"

#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <yandex/maps/wiki/common/moderation.h>

namespace maps {
namespace wiki {

namespace {
const std::string OUTSOURCE_GROUP_NAME_PREFIX = "outsource-group.";
} // namespace

void checkOutsourceConsistency(const ArealObject* obj, Transaction& work)
{
    auto hasCompanyGroup = [](
        const std::string& outsourceGroupName,
        const std::vector<acl::Group>& groups) {
            for (const auto& group : groups) {
                if (group.name() == outsourceGroupName) {
                    return true;
                }
            }
            return false;
        };

    acl::ACLGateway aclGateway(work);
    const auto& companyId = obj->attributes().value(ATTR_OUTSOURCE_REGION_COMPANY_ID);
    const auto& outsourcerLogin = obj->attributes().value(ATTR_OUTSOURCE_REGION_OUTSOURCER_LOGIN);

    auto outsourceGroupName = OUTSOURCE_GROUP_NAME_PREFIX + companyId;

    WIKI_REQUIRE(
        companyId.empty() || hasCompanyGroup(outsourceGroupName, aclGateway.groups()),
        ERR_ATTRIBUTE_VALUE_INVALID,
        "Outsource zone id: " << obj->id()
        << " assigned to invalid company: " << companyId);

    if (outsourcerLogin.empty()) {
        return;
    }

    WIKI_REQUIRE(
        !companyId.empty() &&
            hasCompanyGroup(outsourceGroupName, aclGateway.user(outsourcerLogin).groups()),
        ERR_ATTRIBUTE_VALUE_INVALID,
        "User with login: " << outsourcerLogin
        << " does not belong to company: " << companyId);
}

} // namespace wiki
} // namespace maps
