#pragma once

#include "common.h"
#include "objects/object.h"

#include <list>
#include <map>

namespace maps {
namespace wiki {

/**
 * GeoObjectCollection. The class represents collection of wikimap objects
 */
class GeoObjectCollection
{
public:

    typedef std::list<ObjectPtr> TObjects;
    typedef TObjects::iterator TObjectsIt;
    typedef TObjects::const_iterator TObjectsCIt;

    GeoObjectCollection() {}
    GeoObjectCollection(std::initializer_list<ObjectPtr> objects);
    GeoObjectCollection(const GeoObjectCollection& col);

    GeoObjectCollection& operator = (const GeoObjectCollection& col) = delete;
    GeoObjectCollection& operator = (GeoObjectCollection&& col);

    /**
    * Add object to collection
    * or return pointer to exsiting object with same id
    */
    ObjectPtr add(ObjectPtr ptr);
    void remove(TOid id);
    void append(const GeoObjectCollection& collection);

    GeoObjectCollection find(const ObjectPredicate& predicate) const;

    TObjectsCIt begin() const;
    TObjectsCIt end() const;
    ObjectPtr front() const;
    ObjectPtr back() const;
    bool empty() const;
    size_t size() const;
    void clear();

    ObjectPtr getById(TOid id) const;

    void dump(std::ostream& os) const;

    /** Return primary object if it exists and is unique in the
    *   collection. Otherwise return empty ObjectPtr
    */
    ObjectPtr primaryObject() const;

protected:
    TObjects objects_;
    std::map<TOid, TObjectsIt> objectsMap_;
};

} // namespace wiki
} // namespace maps
