#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/magic_strings.h>

#include <yandex/maps/wiki/configs/editor/size.h>

#include <boost/noncopyable.hpp>

#include <chrono>

namespace maps {
namespace wiki {

class System : boost::noncopyable
{
public:
    struct ResolveResolutionCalcLimits {
        const std::chrono::milliseconds timeoutMs;
        const size_t commitsLimit;
    };

    explicit System(const maps::xml3::Node& node);

    const Size& virtualWindow() const { return virtualWindow_; }

    /// Threshold to determine whether geometry overlaps 180 meridian (Anti-Meridian)
    double antiMeridianOverlapThreshold() const { return antiMeridianOverlapThreshold_; }
    /// Pixel radius to snap geometry to 180 meridian (Anti-Meridian)
    size_t antiMeridianGravityAccuracy() const { return antiMeridianGravityAccuracy_; }

    /// Radius to snap geometry to 180 meridian (Anti-Meridian) at current zoom
    double antiMeridianGravityRadius(TZoom zoom) const;

    size_t slavesPerRoleLimit() const { return slavesPerRoleLimit_; }

    size_t revertObjectsLimit() const { return revertObjectsLimit_; }

    size_t editNoteIndex(const std::string& note) const;

    auto resolveResolutionCalcLimits() const { return resolveResolutionCalcLimits_; }

private:
    Size virtualWindow_;
    double antiMeridianOverlapThreshold_;
    size_t antiMeridianGravityAccuracy_;
    size_t slavesPerRoleLimit_;
    size_t revertObjectsLimit_;
    ResolveResolutionCalcLimits resolveResolutionCalcLimits_;
};

std::string canonicalCategoryIdToPlain(const std::string& canonicalCategoryId);
std::string plainCategoryIdToCanonical(const std::string& plainCategoryId);
StringSet plainCategoryIdsToCanonical(const StringSet& plainCategoryIds);
StringSet removeUndefinedCategories(StringSet&& original);

} // namespace wiki
} // namespace maps
